/**
  ******************************************************************************
  * @file    startup_bl.c 
  * @author  Ruediger R. Asche
  * @version V1.0.0
  * @date    10-December-2015
  * @brief   Entry point for the boot loader
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, THE AUTHOR SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  ******************************************************************************  
  */ 

//#include "master.h"

/* ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// The entry point for the application.
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// */
//extern int main(void);

/* ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Reserve space for the system stack. This is the stack that the startup code runs on until the application entry point is
// called. When the boot loader is in standalone mode, the interrupt handler that processes the host communication also uses
// this stack. Make sure that the stack never overflows!
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// */

#define BOOTSTACKSIZEINWORDS 256
#define IVTENTRYCT 256

typedef void (*IVTVector)(void);

/* ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// The following are constructs created by the linker, indicating where the
// the "data" and "bss" segments reside in memory.  The initializers for the
// "data" segment resides immediately following the "text" segment.
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// */
extern unsigned long _sidata;
extern unsigned long _sdata;
extern unsigned long _edata;
extern unsigned long _sbss;
extern unsigned long _ebss;
extern unsigned long _estack;

extern void PendSV_Handler(void);
extern void SVC_Handler(void);
extern void SysTick_Handler(void);
extern void SystemInit(void);

extern void ENET_1588_Timer_IRQHandler(void);        
extern void ENET_Transmit_IRQHandler(void);                                  
extern void ENET_Receive_IRQHandler(void);

extern void FTM0_IRQHandler(void);
extern void I2C0_IRQHandler(void);
extern void I2C1_IRQHandler(void);

extern void main(void);


static void NmiSR(void)
{
    for(;;){}
}

static void FaultISR(void)
{
    for (;;){}
}

static  void IntDefaultHandler(void)
{
    for (;;){}
}

static void BusFault(void)
{
    for (;;){}
}

static void ResetISR(void)
{
    unsigned    long    *a_Src,*a_Dst;
    // this sequence deactivates the Watchdog which is active out of reset in the Kinetis processor.
    *((unsigned short *)0x4005200e) = 0xc520;
    *((unsigned short *)0x4005200e) = 0xd928;
    *((unsigned short *)0x40052000) = 0x1d2;
	__asm volatile(
					" cpsid i				\n" /* Globally enable interrupts. */);
    // Copy the data segment initializers from flash to SRAM.
    a_Src = &_sidata;
    for(a_Dst = &_sdata; a_Dst < &_edata; )
    {
        *a_Dst++ = *a_Src++;
    }
    // Zero fill the bss segment.
    for(a_Dst = &_sbss; a_Dst < &_ebss; )
    {
        *a_Dst++ = 0;
    }
    SystemInit();
    // Call the application's entry point. An application will frequently call the startup entry point of the C runtime
    // initialization, ie __start which will eventually call main(). But we are in the boot loader here, so we can not
    // afford to have additional code that steals code space and does things we do not have control over.
    main();
}

__attribute__ ((section(".isr_vector")))
IVTVector g_pfnVectorsBL[IVTENTRYCT] =
{
    // this layout of the IVT corresponds to the STM32F4xx family of controllers.
    (IVTVector)(unsigned long)&_estack,                  // initial stack pointer          @0x0000_0000
    ResetISR,                                                  // reset handler                  @0x0000_0004
    NmiSR,                                                     // NMI handler                    @0x0000_0008
    FaultISR,                                                  // hard fault handler             @0x0000_000C
    IntDefaultHandler,                                         // MPU fault handler              @0x0000_0010
    BusFault,                                                  // bus fault handler              @0x0000_0014
    IntDefaultHandler,                                         // usage fault handler            @0x0000_0018
    0,                                                            // Reserved                       @0x0000_001C
    0,                                                            // Reserved                       @0x0000_0020
    0,                                                            // Reserved                       @0x0000_0024
    0,                                                            // Reserved                       @0x0000_0028
    SVC_Handler,                                            // SVCall handler                 @0x0000_002C
    IntDefaultHandler,                                         // Debug monitor handler          @0x0000_0030
    0,                                                            // Reserved                       @0x0000_0034
    PendSV_Handler,                                         // PendSV handler                 @0x0000_0038
    SysTick_Handler,                                           // SysTick handler                @0x0000_003C
    /* External Interrupts */
    IntDefaultHandler,                                         // @0x0000_0040  DMA Channel 0 Transfer Complete                                  
    IntDefaultHandler,                                         // @0x0000_0044  DMA Channel 1 Transfer Complete          
    IntDefaultHandler,                                         // @0x0000_0048  DMA Channel 2 Transfer Complete          
    IntDefaultHandler,                                         // @0x0000_004C  DMA Channel 3 Transfer Complete         
    IntDefaultHandler,                                         // @0x0000_0050  DMA Channel 4 Transfer Complete                         
    IntDefaultHandler,                                         // @0x0000_0054  DMA Channel 5 Transfer Complete                           
    IntDefaultHandler,                                         // @0x0000_0058  DMA Channel 6 Transfer Complete       
    IntDefaultHandler,                                         // @0x0000_005C  DMA Channel 7 Transfer Complete
    IntDefaultHandler,                                         // @0x0000_0060  DMA Channel 8 Transfer Complete         
    IntDefaultHandler,                                         // @0x0000_0064  DMA Channel 9 Transfer Complete         
    IntDefaultHandler,                                         // @0x0000_0068  DMA Channel 10 Transfer Complete         
    IntDefaultHandler,                                         // @0x0000_006C  DMA Channel 11 Transfer Complete 
    IntDefaultHandler,                                         // @0x0000_0070  DMA Channel 12 Transfer Complete  
    IntDefaultHandler,                                         // @0x0000_0074  DMA Channel 13 Transfer Complete  
    IntDefaultHandler,                                         // @0x0000_0078  DMA Channel 14 Transfer Complete  
    IntDefaultHandler,                                         // @0x0000_007C  DMA Channel 15 Transfer Complete  
    IntDefaultHandler,                                         // @0x0000_0080  DMA Error Interrupt  
    IntDefaultHandler,                                         // @0x0000_0084  Normal Interrupt  
    IntDefaultHandler,                                         // @0x0000_0088  FTFE Command complete interrupt  
    IntDefaultHandler,                                         // @0x0000_008C  Read Collision Interrupt        
    IntDefaultHandler,                                         // @0x0000_0090  Low Voltage Detect, Low Voltage Warning         
    IntDefaultHandler,                                         // @0x0000_0094  Low Leakage Wakeup Unit         
    IntDefaultHandler,                                         // @0x0000_0098  WDOG Interrupt         
    IntDefaultHandler,                                         // @0x0000_009C  RNG Interrupt         
    I2C0_IRQHandler,                                         // @0x0000_00A0  I2C0 interrupt
    I2C1_IRQHandler,                                         // @0x0000_00A4  I2C1 interrupt
    IntDefaultHandler,                                         // @0x0000_00A8  SPI0 Interrupt
    IntDefaultHandler,                                         // @0x0000_00AC  SPI1 Interrupt         
    IntDefaultHandler,                                         // @0x0000_00B0  I2S0 transmit interrupt  
    IntDefaultHandler,                                         // @0x0000_00B4  I2S0 receive interrupt  
    IntDefaultHandler,                                         // @0x0000_00B8  UART0 LON interrupt  
    IntDefaultHandler,                                         // @0x0000_00BC  UART0 Receive/Transmit interrupt         
    IntDefaultHandler,                                         // @0x0000_00C0  UART0 Error interrupt         
    IntDefaultHandler,                                         // @0x0000_00C4  UART1 Receive/Transmit interrupt         
    IntDefaultHandler,                                         // @0x0000_00C8  UART1 Error interrupt           
    IntDefaultHandler,                                         // @0x0000_00CC  UART2 Receive/Transmit interrupt  
    IntDefaultHandler,                                         // @0x0000_00D0  UART2 Error interrupt  
    IntDefaultHandler,                                         // @0x0000_00D4  UART3 Receive/Transmit interrupt  
    IntDefaultHandler,                                         // @0x0000_00D8  UART3 Error interrupt  
    IntDefaultHandler,                                         // @0x0000_00DC  ADC0 interrupt  
    IntDefaultHandler,                                         // @0x0000_00E0  CMP0 interrupt         
    IntDefaultHandler,                                         // @0x0000_00E4  CMP1 interrupt         
    IntDefaultHandler,                                         // @0x0000_00E8  FTM0 fault, overflow and channels interrupt             
    IntDefaultHandler,                                         // @0x0000_00EC  FTM1 fault, overflow and channels interrupt
    IntDefaultHandler,                                         // @0x0000_00F0  FTM2 fault, overflow and channels interrupt
    IntDefaultHandler,                                         // @0x0000_00F4  CMT interrupt
    IntDefaultHandler,                                         // @0x0000_00F8  RTC interrupt         
    IntDefaultHandler,                                         // @0x0000_00FC  RTC seconds interrupt         
    IntDefaultHandler,                                         // @0x0000_0100  PIT timer channel 0 interrupt  
    IntDefaultHandler,                                         // @0x0000_0104  PIT timer channel 1 interrupt  
    IntDefaultHandler,                                         // @0x0000_0108  PIT timer channel 2 interrupt  
    IntDefaultHandler,                                         // @0x0000_010C  PIT timer channel 3 interrupt  
    IntDefaultHandler,                                         // @0x0000_0110  PDB0 Interrupt  
    IntDefaultHandler,                                         // @0x0000_0114  USB0 interrupt  
    IntDefaultHandler,                                         // @0x0000_0118  USBDCD Interrupt     
    IntDefaultHandler,                                         // @0x0000_011C  Reserved interrupt 71
    IntDefaultHandler,                                         // @0x0000_0120  DAC0 interrupt  
    IntDefaultHandler,                                         // @0x0000_0124  MCG Interrupt  
    IntDefaultHandler,                                         // @0x0000_0128  LPTimer interrupt  
    IntDefaultHandler,                                         // @0x0000_012C  Port A interrupt  
    IntDefaultHandler,                                         // @0x0000_0130  Port B interrupt  
    IntDefaultHandler,                                         // @0x0000_0134  Port C interrupt  
    IntDefaultHandler,                                         // @0x0000_0138  Port D interrupt         
    IntDefaultHandler,                                         // @0x0000_013C  Port E interrupt         
    IntDefaultHandler,                                         // @0x0000_0140  Software interrupt         
    IntDefaultHandler,                                         // @0x0000_0144  SPI2 Interrupt         
    IntDefaultHandler,                                         // @0x0000_0148  UART4 Receive/Transmit interrupt         
    IntDefaultHandler,                                         // @0x0000_014C  UART4 Error interrupt  
    IntDefaultHandler,                                         // @0x0000_0150  UART5 Receive/Transmit interrupt  
    IntDefaultHandler,                                         // @0x0000_0154  UART5 Error interrupt  
    IntDefaultHandler,                                         // @0x0000_0158  CMP2 interrupt  
    IntDefaultHandler,                                         // @0x0000_015C  FTM3 fault, overflow and channels interrupt   
    IntDefaultHandler,                                         // @0x0000_0160  DAC1 interrupt         
    IntDefaultHandler,                                         // @0x0000_0164  ADC1 interrupt         
    IntDefaultHandler,                                         // @0x0000_0168  I2C2 interrupt  
    IntDefaultHandler,                                         // @0x0000_016C  CAN0 OR'd message buffers interrupt  
    IntDefaultHandler,                                         // @0x0000_0170  CAN0 bus off interrupt          
    IntDefaultHandler,                                         // @0x0000_0174  CAN0 error interrupt  
    IntDefaultHandler,                                         // @0x0000_0178  CAN0 Tx warning interrupt  
    IntDefaultHandler,                                         // @0x0000_017C  CAN0 Rx warning interrupt  
    IntDefaultHandler,                                         // @0x0000_0180  CAN0 wake up interrupt
    IntDefaultHandler,                                         // @0x0000_0184  SDHC interrupt  
    ENET_1588_Timer_IRQHandler,                                // @0x0000_0188  Ethernet MAC IEEE 1588 Timer Interrupt         
    ENET_Transmit_IRQHandler,                                  // @0x0000_018C  Ethernet MAC Transmit Interrupt  
    ENET_Receive_IRQHandler,                                   // @0x0000_0190  Ethernet MAC Receive Interrupt  
    IntDefaultHandler,                                         // @0x0000_0194  Ethernet MAC Error and miscelaneous Interrupt          
    IntDefaultHandler,                                         // @0x0000_0198  102  
    IntDefaultHandler,                                         // @0x0000_019C  103  
    IntDefaultHandler,                                         // @0x0000_01A0  104  
    IntDefaultHandler,                                         // @0x0000_01A4  105
    IntDefaultHandler,                                         // @0x0000_01A8  106        
    IntDefaultHandler,                                         // @0x0000_01A8  107
    IntDefaultHandler,                                         // @0x0000_01AC  108
    IntDefaultHandler,                                         // @0x0000_01B0  109
    IntDefaultHandler,                                         // @0x0000_01B4  110
    IntDefaultHandler,                                         // @0x0000_01B8  111
    IntDefaultHandler,                                         // @0x0000_01BC  112
    IntDefaultHandler,                                         // @0x0000_01C0  113
    IntDefaultHandler,                                         // @0x0000_01C4  114
    IntDefaultHandler,                                         // @0x0000_01C8  115
    IntDefaultHandler,                                         // @0x0000_01CC  116
    IntDefaultHandler,                                         // @0x0000_01D0  117
    IntDefaultHandler,                                         // @0x0000_01D4  118
    IntDefaultHandler,                                         // @0x0000_01D8  119
    IntDefaultHandler,                                         // @0x0000_01DC  120
    IntDefaultHandler,                                         // @0x0000_01E0  121
    IntDefaultHandler,                                         // @0x0000_01E4  122
    IntDefaultHandler,                                         // @0x0000_01E8  123
    IntDefaultHandler,                                         // @0x0000_01EC  124
    IntDefaultHandler,                                         // @0x0000_01F0  125
    IntDefaultHandler,                                         // @0x0000_01F4  126
    IntDefaultHandler,                                         // @0x0000_01F8  127
    IntDefaultHandler,                                         // @0x0000_01FC  128
    IntDefaultHandler,                                         // @0x0000_0200  129
    IntDefaultHandler,                                         // @0x0000_0204  130
    IntDefaultHandler,                                         // @0x0000_0208  131
    IntDefaultHandler,                                         // @0x0000_020C  132
    IntDefaultHandler,                                         // @0x0000_0210  133
    IntDefaultHandler,                                         // @0x0000_0214  134
    IntDefaultHandler,                                         // @0x0000_0218  135
    IntDefaultHandler,                                         // @0x0000_021C  136
    IntDefaultHandler,                                         // @0x0000_0220  137
    IntDefaultHandler,                                         // @0x0000_0224  138
    IntDefaultHandler,                                         // @0x0000_0228  139
    IntDefaultHandler,                                         // @0x0000_022C  140
    IntDefaultHandler,                                         // @0x0000_0230  141
    IntDefaultHandler,                                         // @0x0000_0234  142
    IntDefaultHandler,                                         // @0x0000_0238  143
    IntDefaultHandler,                                         // @0x0000_023C  144
    IntDefaultHandler,                                         // @0x0000_0240  145
    IntDefaultHandler,                                         // @0x0000_0244  146
    IntDefaultHandler,                                         // @0x0000_0248  147
    IntDefaultHandler,                                         // @0x0000_024C  148
    IntDefaultHandler,                                         // @0x0000_0250  149
    IntDefaultHandler,                                         // @0x0000_0254  150
    IntDefaultHandler,                                         // @0x0000_0258  151
    IntDefaultHandler,                                         // @0x0000_025C  152
    IntDefaultHandler,                                         // @0x0000_0260  153
    IntDefaultHandler,                                         // @0x0000_0264  154
    IntDefaultHandler,                                         // @0x0000_0268  155
    IntDefaultHandler,                                         // @0x0000_026C  156
    IntDefaultHandler,                                         // @0x0000_0270  157
    IntDefaultHandler,                                         // @0x0000_0274  158
    IntDefaultHandler,                                         // @0x0000_0278  159
    IntDefaultHandler,                                         // @0x0000_027C  160
    IntDefaultHandler,                                         // @0x0000_0280  161
    IntDefaultHandler,                                         // @0x0000_0284  162
    IntDefaultHandler,                                         // @0x0000_0288  163
    IntDefaultHandler,                                         // @0x0000_028C  164
    IntDefaultHandler,                                         // @0x0000_0290  165
    IntDefaultHandler,                                         // @0x0000_0294  166
    IntDefaultHandler,                                         // @0x0000_0298  167
    IntDefaultHandler,                                         // @0x0000_029C  168
    IntDefaultHandler,                                         // @0x0000_02A0  169
    IntDefaultHandler,                                         // @0x0000_02A4  170
    IntDefaultHandler,                                         // @0x0000_02A8  171
    IntDefaultHandler,                                         // @0x0000_02AC  172
    IntDefaultHandler,                                         // @0x0000_02B0  173
    IntDefaultHandler,                                         // @0x0000_02B4  174
    IntDefaultHandler,                                         // @0x0000_02B8  175
    IntDefaultHandler,                                         // @0x0000_02BC  176
    IntDefaultHandler,                                         // @0x0000_02C0  177
    IntDefaultHandler,                                         // @0x0000_02C4  178
    IntDefaultHandler,                                         // @0x0000_02C8  179
    IntDefaultHandler,                                         // @0x0000_02CC  180
    IntDefaultHandler,                                         // @0x0000_02D0  181
    IntDefaultHandler,                                         // @0x0000_02D4  182
    IntDefaultHandler,                                         // @0x0000_02D8  183
    IntDefaultHandler,                                         // @0x0000_02DC  184
    IntDefaultHandler,                                         // @0x0000_02E0  185
    IntDefaultHandler,                                         // @0x0000_02E4  186
    IntDefaultHandler,                                         // @0x0000_02E8  187
    IntDefaultHandler,                                         // @0x0000_02EC  188
    IntDefaultHandler,                                         // @0x0000_02F0  189
    IntDefaultHandler,                                         // @0x0000_02F4  190
    IntDefaultHandler,                                         // @0x0000_02F8  191
    IntDefaultHandler,                                         // @0x0000_02FC  192
    IntDefaultHandler,                                         // @0x0000_0300  193
    IntDefaultHandler,                                         // @0x0000_0304  194
    IntDefaultHandler,                                         // @0x0000_0308  195
    IntDefaultHandler,                                         // @0x0000_030C  196
    IntDefaultHandler,                                         // @0x0000_0310  197
    IntDefaultHandler,                                         // @0x0000_0314  198
    IntDefaultHandler,                                         // @0x0000_0318  199
    IntDefaultHandler,                                         // @0x0000_031C  200
    IntDefaultHandler,                                         // @0x0000_0320  201
    IntDefaultHandler,                                         // @0x0000_0324  202
    IntDefaultHandler,                                         // @0x0000_0328  203
    IntDefaultHandler,                                         // @0x0000_032C  204
    IntDefaultHandler,                                         // @0x0000_0330  205
    IntDefaultHandler,                                         // @0x0000_0334  206
    IntDefaultHandler,                                         // @0x0000_0338  207
    IntDefaultHandler,                                         // @0x0000_033C  208
    IntDefaultHandler,                                         // @0x0000_0340  209
    IntDefaultHandler,                                         // @0x0000_0344  210
    IntDefaultHandler,                                         // @0x0000_0348  211
    IntDefaultHandler,                                         // @0x0000_034C  212
    IntDefaultHandler,                                         // @0x0000_0350  213
    IntDefaultHandler,                                         // @0x0000_0354  214
    IntDefaultHandler,                                         // @0x0000_0358  215
    IntDefaultHandler,                                         // @0x0000_035C  216
    IntDefaultHandler,                                         // @0x0000_0360  217
    IntDefaultHandler,                                         // @0x0000_0364  218
    IntDefaultHandler,                                         // @0x0000_0368  219
    IntDefaultHandler,                                         // @0x0000_036C  220
    IntDefaultHandler,                                         // @0x0000_0370  221
    IntDefaultHandler,                                         // @0x0000_0374  222
    IntDefaultHandler,                                         // @0x0000_0378  223
    IntDefaultHandler,                                         // @0x0000_037C  224
    IntDefaultHandler,                                         // @0x0000_0380  225
    IntDefaultHandler,                                         // @0x0000_0384  226
    IntDefaultHandler,                                         // @0x0000_0388  227
    IntDefaultHandler,                                         // @0x0000_038C  228
    IntDefaultHandler,                                         // @0x0000_0390  229
    IntDefaultHandler,                                         // @0x0000_0394  230
    IntDefaultHandler,                                         // @0x0000_0398  231
    IntDefaultHandler,                                         // @0x0000_03A0  232
    IntDefaultHandler,                                         // @0x0000_03A4  233
    IntDefaultHandler,                                         // @0x0000_03A8  234
    IntDefaultHandler,                                         // @0x0000_03AC  235
    IntDefaultHandler,                                         // @0x0000_03B0  236
    IntDefaultHandler,                                         // @0x0000_03B4  237
    IntDefaultHandler,                                         // @0x0000_03B8  238
    IntDefaultHandler,                                         // @0x0000_03BC  239
    IntDefaultHandler,                                         // @0x0000_03C0  240
    IntDefaultHandler,                                         // @0x0000_03C4  241
    IntDefaultHandler,                                         // @0x0000_03C8  242
    IntDefaultHandler,                                         // @0x0000_03CC  243
    IntDefaultHandler,                                         // @0x0000_03D0  244
    IntDefaultHandler,                                         // @0x0000_03D4  245
    IntDefaultHandler,                                         // @0x0000_03D8  246
    IntDefaultHandler,                                         // @0x0000_03DC  247
    IntDefaultHandler,                                         // @0x0000_03E0  248
    IntDefaultHandler,                                         // @0x0000_03E4  249
    IntDefaultHandler,                                         // @0x0000_03E8  250
    IntDefaultHandler,                                         // @0x0000_03EC  251
    IntDefaultHandler,                                         // @0x0000_03F0  252
    IntDefaultHandler,                                         // @0x0000_03F4  253
    IntDefaultHandler,                                         // @0x0000_03F8  254
    IntDefaultHandler,                                         // @0x0000_03FC   Reserved for user TRIM value
};
